#ifndef _SCRIPT_
#define _SCRIPT_
typedef enum ScriptEventType ScriptEventType;
typedef struct ScriptEvent ScriptEvent;
typedef struct ScriptState ScriptState;
#include "common.h"
#include "player.h"
enum ScriptEventType {
    SetKx,
    SetKy,
    SetCutscene,
    SetSpeech,
    SetSwitch,
    SetVisible,
    SetMusic,
    SetDead
};
struct ScriptEvent {
    int timestamp;
    ScriptEventType et;
    PlayerType who;
    char * value;
};
struct ScriptState {
    LandList * events;
    ScriptEvent * current;
    int last_tick;
    int skipped;
};
ScriptState* global_script_state(void);
int speech_time(str text);
void script_reset(void);
void add_event_absolute(float seconds, ScriptEventType et, PlayerType who, str value);
void add_event(float seconds, ScriptEventType et, PlayerType who, str value);
void script_init_for_level(void);
void script_tick(void);
void script_skip(void);
void script_off(void);
void script_tom(void);
void script_fox(void);
void script_beaver(void);
void script_racoon(void);
#endif
